import crypto from"node:crypto";import fs from"node:fs";import os from"node:os";import path from"node:path";import{ServerSettings as CommonServerSettings}from"../../common/config.mjs";import*as fields from"../../common/data/fields.mjs";import{PASSWORD_SAFE_STRING}from"../../common/constants.mjs";import{getSalt,hashPassword}from"./auth.mjs";import{mergeObject}from"../../common/utils/helpers.mjs";import Files from"../files/files.mjs";import License from"./license.mjs";export class ConfigPathField extends fields.StringField{static get _defaults(){return mergeObject(super._defaults,{required:!0,blank:!1,nullable:!0,initial:null,mustExist:!0})}_validateType(e){const t=path.isAbsolute(e)?e:path.join(paths.config,e);if(this.mustExist&&!fs.existsSync(t))throw new Error(`File path "${t}" does not exist`)}_cast(e){return Files.standardizePath(e)}initialize(e,t,i={}){return null===e?null:path.isAbsolute(e)?e:path.join(paths.config,e)}}export default class ServerSettings extends CommonServerSettings{static defineSchema(){const e=super.defineSchema();return e.awsConfig=new ConfigPathField(e.awsConfig.options),e.dataPath=new ConfigPathField({validate:ServerSettings.#e,mustExist:!1,...e.dataPath.options}),e.demo=new fields.SchemaField({worldName:new fields.StringField({required:!0,blank:!1,nullable:!0,initial:null}),sourceZip:new ConfigPathField({initial:null}),resetSeconds:new fields.NumberField({required:!0,integer:!0,positive:!0,initial:3600}),allowGMReset:new fields.BooleanField}),e.serviceConfig=new ConfigPathField,e.sslCert=new ConfigPathField(e.sslCert.options),e.sslKey=new ConfigPathField(e.sslKey.options),e.hotReload=new fields.BooleanField({initial:!1}),e}debug;noupdate;noIPDiscovery;demoMode;isElectron;isNode;isSSL;service;static#e(e){const t=global.paths,i=path.dirname(t.root),s="resources"===path.basename(i)?path.dirname(i):t.root,o=path.relative(s,e);if(!o.startsWith("..")&&!path.isAbsolute(o))throw new Error(`The data path ${e} must not be inside the application location ${t.root}.`)}initialize(e){const t={};e.nobackups&&(t.noBackups=!0),e.noupnp&&(t.upnp=!1),e.hotReload&&(t.hotReload=!0),e.fullscreen&&(t.fullscreen=!0),e.port&&(t.port=Number(e.port)),e.world&&(t.world=String(e.world));let i=!1;try{this.updateSource(t,{dryRun:!0}),i=!0}catch(e){const t=new Error("Failed to apply command-line parameters",{cause:e});console.error(t)}i&&this.updateSource(t),this.isElectron=process.versions.hasOwnProperty("electron"),this.isNode=!this.isElectron,this.isSSL=!!this.sslKey&&!!this.sslCert,this.debug=e.debug&&fs.existsSync(`${paths.root}/server`),this.noupdate=!!e.noupdate,this.noIPDiscovery=!!e.noipdiscovery,"string"==typeof e.demo&&this.#t(e.demo),this.demoMode=!0===e.demo||!!this.demo.sourceZip,"adminPassword"in e&&!this.adminPassword&&this.setAdministratorPassword(e.adminPassword),this.service="serviceKey"in e?this.#i(e.serviceKey):{id:os.hostname().replace(/[^\x00-\x7F]/g,"?")},this.log()}#i(e){if(!this.serviceConfig)throw new Error("A serviceKey was provided but no service configuration file is present.");const t=JSON.parse(fs.readFileSync(this.serviceConfig,"utf8")),i=crypto.createPublicKey(License.PUBLIC_KEY),s=crypto.createVerify("SHA256"),o=JSON.stringify({id:t.id,key:e});if(s.write(o),s.end(),!s.verify(i,t.signature,"base64"))throw new Error("Invalid service configuration provider credentials");return logger.info(`Service provider configuration successfully loaded for ${t.id}`),t.key=e,t}#t(e){if(e=fs.existsSync(e)?e:path.join(paths.config,e),!fs.existsSync(e))throw new Error(`Invalid demo mode configuration path ${e}`);const t=JSON.parse(fs.readFileSync(e,"utf8"));this.updateSource({demo:t})}save(e){e=e??global.paths.options;const t=this.toObject();return delete t.adminPassword,delete t.noBackups,this.demoMode||delete t.demo,fs.writeFileSync(e,JSON.stringify(t,null,2)),logger.info(`Saved application configuration options to ${e}`),this}static load(){const e=global.paths,t=JSON.parse(fs.readFileSync(e.options,"utf8"));t.dataPath=e.user;const i=path.join(e.config,"admin.txt");t.adminPassword=fs.existsSync(i)?fs.readFileSync(i,"utf8"):null;const s=new this(t,{strict:!0,fallback:!0});for(const e of Object.values(s.validationFailures))e&&global.startupMessages.push({level:"error",message:e.toString()});return s}vend(){const e=this.toObject();for(let t of Object.keys(e))CommonServerSettings.schema.has(t)||delete e[t];return e}log(e){e=e||global.logger;const t=this.toObject(),i=e=>e&&"string"==typeof e?"*".repeat(6)+"/"+path.basename(e):e;for(let e of["awsConfig","sslKey","sslCert","serviceConfig"])t[e]=i(t[e]);t.demo.sourceZip=i(t.demo.sourceZip),delete t.dataPath,this.adminPassword&&(t.adminPassword=PASSWORD_SAFE_STRING),this.demoMode||delete t.demo,e.info(`Application Options:\n${JSON.stringify(t,null,2)}`)}setAdministratorPassword(e){if(e===PASSWORD_SAFE_STRING)return!1;const t=path.join(global.paths.config,"admin.txt");if(!e){if("adminPassword"in this.updateSource({adminPassword:null})){try{fs.unlinkSync(t)}catch(e){}return!0}return!1}if("string"!=typeof e)throw new Error("The administrator password must be a string");const i=getSalt(this.passwordSalt),s=hashPassword(e,i);return"adminPassword"in this.updateSource({adminPassword:s})&&(fs.writeFileSync(t,s),logger.info(`Server administrator password updated in "${t}"`),!0)}}