import DatabaseBackend from"../../../common/abstract/backend.mjs";import{isEmpty,filterObject,parseUuid,setProperty}from"../../../common/utils/helpers.mjs";import ServerError from"../../server/error.mjs";import DocumentSocketResponse from"../../../common/abstract/socket.mjs";export default class ServerDatabaseBackend extends DatabaseBackend{static#e=["data","updates","ids","parent","parentUuid","pack","restoreDelta","deleteAll","_result"];socketListeners(e){e.on("modifyDocument",this.#t.bind(this,e))}async#t(e,t,a){const o=e.user;if(!o)throw new Error("Unrecognized User for modifyDocument socket operation");t.userId=o.id;const{action:r,type:n,operation:i}=t;if(!(this[r]instanceof Function))throw new Error(`Invalid action "${r}" provided to "modifyDocument" operation`);if(!db[n])throw new Error(`Invalid Document "${n}" provided to "modifyDocument" operation`);const d=new DocumentSocketResponse(t);try{d.result=await this.modifyDocument(t,o),d.broadcast=i.broadcast??!0}catch(e){d.error=new ServerError(e.message,e.stack),d.broadcast=!1,logger.error(d.error)}a(d),d.result.length&&d.broadcast&&e.broadcast.emit("modifyDocument",d)}async modifyDocument(e,t){const a=global.db,{action:o,type:r,operation:n}=e,{pack:i,parentUuid:d}=n,s=this[o];if(!(s instanceof Function))throw new Error(`Invalid Document modification action "${o}" requested`);let c,l=a[r];if(!l)throw new Error(`Invalid Document "${r}" provided for database modification operation`);if(i){const e=a.packs.get(i);if("Folder"===r)l=e.folderClass;else if(!d){if(r!==e.packData.type)throw new Error(`${r} Documents cannot be created in a compendium that only allows for ${e.packData.type} Documents.`);l=e}e.connected||await e.connect()}c=i?a.packs.get(i).db:d?parseUuid(d)?.collection.db:l.db;const p=await c.semaphore.add(s.bind(this),l,n,t),u=n._result??p;return delete n._result,u}emit(e,t,a=[],o={},r=null){const n=new DocumentSocketResponse({type:e,action:t,operation:o,broadcast:!0,result:a,userId:r?.id});global.express.io.emit("modifyDocument",n)}async _getDocuments(e,t,a){const{query:o,index:r,parent:n}=t;if(n){const a=t.parent.getEmbeddedCollection(e.documentName);return Array.from(a.values())}return r?this.#a(e,t):e.find(o,{safe:!0})}async#a(e,t){let{query:a,indexFields:o}=t;o||=e.metadata.compendiumIndexFields;const r=["password","passwordSalt"],n={};for(const e of o){if(r.includes(e))throw new Error(`You are not allowed to request the "${e}" field as a compendium index.`);setProperty(n,e,1)}const i={};for(const[t,a]of Object.entries(n)){const o=e.hierarchy[t];if(o){if(i[t]={},"object"==typeof a)i[t]=a;else for(const e of o.model.metadata.compendiumIndexFields)i[t][e]=1;i[t]._id=1,n[t]=1}}const d=await e.sublevel.find(a,{project:n});if(isEmpty(i))return d;for(const t of d){await e.expandEmbedded(t,{partial:!0});for(const[e,a]of Object.entries(i)){const o=t[e];Array.isArray(o)?t[e]=o.map((e=>filterObject(e,a))):t[e]=filterObject(o,a)}}return d}async _createDocuments(e,t,a){const{data:o,parent:r,parentUuid:n,pack:i,restoreDelta:d,...s}=t,c=e.documentName,l=e.collectionName,p=r?r.getSublevel(l):e.sublevel,u=r?.getEmbeddedCollection(l);u&&(e=u.documentClass);const m=[],f={};await Promise.all(o.map((async t=>{if(s.keepId&&t._id||(t._id=await p.createNewId()),u?.has(t._id))throw new Error(`The _id [${t._id}] already exists within the parent collection: ${r.documentName} [${r.id}] ${l}`);f[t._id]=t,await e.preprocessData(t,{user:a,documentId:t._id,creation:!0});const o=e.fromSource(t,{parent:r,pack:i});m.push(o)}))),t._createData=f;if(!1===await e._preCreateOperation(m,t,a))return global.logger.debug(`${c} creation operation prevented by _preCreateOperation`),[];const b=p.db.batch(),w=[];for(const e of m){const t=f[e._id];if(await e.loadRelatedDocuments(),a&&!e.canUserModify(a,"create",t))throw new Error(this._logError(a,"create",e,{parent:r,pack:i}));!1!==await e._preCreate(t,s,a)?(e.validate({fields:!0,joint:!0,strict:!0}),r&&u.set(e.id,e,{restoreDelta:d}),e.batchWrite(b,{restoreDelta:d}),w.push((async()=>{const t=e.toObject();return await e._onCreate(t,s,a),t}))):global.logger.debug(`${c} creation was prevented by _preCreate, skipping this Document`)}r&&r.batchWrite(b,{writeEmbedded:!1,childModified:!0}),await b.write(),t.data=t._result=await Promise.all(w.map((e=>e()))),e.isCached&&!r&&game.documentCache.addAll(m);for(const e of ServerDatabaseBackend.#e)delete s[e];return Object.assign(t,s),await e._onCreateOperation(m,t,a),delete t._createData,this._logOperation("Created",c,m,{level:"info",parent:r,pack:i}),m}async _updateDocuments(e,t,a){const{updates:o,parent:r,parentUuid:n,pack:i,restoreDelta:d,...s}=t,c=e.documentName,l=e.collectionName,p=r?r.getSublevel(l):e.sublevel,u=r?.getEmbeddedCollection(l),m={},f=[],b=[];for(const t of o){const o=t._id;if(!o)throw new Error(`You cannot update a ${c} without providing an _id`);if(m[o]=t,r){const r=u.get(o,{invalid:!0});await e.preprocessData(t,{document:r,user:a,creation:!1}),b.push(r)}else f.push(o)}if(f.length){const t=await e.getMany(f);for(let o=0;o<f.length;o++){const r=t[o];if(f[o]!==r?._id)throw new Error(`${c} "${f[o]}" does not exist!`);await e.preprocessData(m[r.id],{document:r,user:a,creation:!1}),b.push(r)}}t._updateData=m;if(!1===await e._preUpdateOperation(b,t,a))return global.logger.debug(`${c} update operation prevented by _preUpdateOperation`),[];const w=p.db.batch(),h=[];await Promise.all(b.map((async o=>{const n=m[o.id];await o.loadRelatedDocuments();for(const t of Object.keys(e.hierarchy))if(t in n)for(const e of o.getEmbeddedCollection(t))await e.loadRelatedDocuments();if(a&&!o.canUserModify(a,"update",n))throw new Error(this._logError(a,"update",o,{parent:r,pack:i}));if(!1===await o._preUpdate(n,s,a))return void global.logger.debug(`${c} update prevented by _preUpdate`);delete n._id;const l=o.updateSource(n,s);l._id=o.id,r&&u.set(o.id,o,{restoreDelta:d});const p=s._wasAdopted||await this.#o(o,n,w,t);delete s._wasAdopted,o.batchWrite(w,{writeEmbedded:p,restoreDelta:d}),h.push((async()=>(await o._onUpdate(l,s,a),l)))}))),r&&r.batchWrite(w,{writeEmbedded:!1,childModified:!0}),await w.write(),t.updates=t._result=await Promise.all(h.map((e=>e()))),e.isCached&&!r&&game.documentCache.addAll(b);for(const e of ServerDatabaseBackend.#e)delete s[e];return Object.assign(t,s),await e._onUpdateOperation(b,t,a),delete t._updateData,global.options.debug&&this._logOperation("Updated",c,b,{level:"debug",parent:r,pack:i}),b}async#o(e,t,a,o){const{recursive:r,restoreDelta:n}=o;let i=!1;for(const[o,d]of Object.entries(e.constructor.hierarchy))o in t&&(i=!0,!1===r&&d._dbDeleteBranch?.(e,a,{restoreDelta:n}));return i&&await e._generateEmbeddedDocumentIds(),i}async _deleteDocuments(e,t,a){const{ids:o,deleteAll:r,parent:n,parentUuid:i,pack:d,...s}=t,c=e.documentName,l=e.collectionName,p=n?n.getSublevel(l):e.sublevel,u=n?.getEmbeddedCollection(l),m=n?o.map((e=>u.get(e,{invalid:!0}))):await e.getMany(o);if(!1===await e._preDeleteOperation(m,t,a))return global.logger.debug(`${c} update operation prevented by _preDeleteOperation`),[];const f=p.db.batch(),b=[];await Promise.all(m.map((async(e,t)=>{if(!e)throw new Error(`${c} "${o[t]}" does not exist!`);if(await e.loadRelatedDocuments(),e.invalid&&a.isGM)return n&&u.delete(e.id),void e.batchDelete(f);if(a&&!e.canUserModify(a,"delete"))throw new Error(this._logError(a,"delete",e,{parent:n,pack:d}));!1!==await e._preDelete(s,a)?(n&&u.delete(e.id),e.batchDelete(f),b.push((async()=>(await e._onDelete(s,a),e.id)))):global.logger.debug(`${c} deletion prevented by _preDelete`)}))),n&&n.batchWrite(f,{writeEmbedded:!1,childModified:!0}),await f.write(),t.ids=t._result=await Promise.all(b.map((e=>e()))),e.isCached&&!n&&game.documentCache.deleteAll(m);for(const e of ServerDatabaseBackend.#e)delete s[e];return Object.assign(t,s),await e._onDeleteOperation(m,t,a),this._logOperation("Deleted",c,m,{level:"info",parent:n,pack:d}),m}getCompendiumScopes(){return Array.from(global.db.packs.keys())}_log(e,t){global.logger[e](t)}}