"use strict";
require("./AssetExtension.js");
var Assets = require("./Assets.js");
require("./cache/index.js");
require("./detections/index.js");
require("./loader/index.js");
require("./resolver/index.js");
require("./types.js");
require("./utils/index.js");
var Cache = require("./cache/Cache.js"), cacheTextureArray = require("./cache/parsers/cacheTextureArray.js"), detectAvif = require("./detections/parsers/detectAvif.js"), detectWebp = require("./detections/parsers/detectWebp.js"), detectDefaults = require("./detections/parsers/detectDefaults.js"), detectWebm = require("./detections/parsers/detectWebm.js"), detectMp4 = require("./detections/parsers/detectMp4.js"), detectOgv = require("./detections/parsers/detectOgv.js"), LoaderParser = require("./loader/parsers/LoaderParser.js"), loadJson = require("./loader/parsers/loadJson.js"), loadTxt = require("./loader/parsers/loadTxt.js"), loadWebFont = require("./loader/parsers/loadWebFont.js"), loadSVG = require("./loader/parsers/textures/loadSVG.js"), loadTextures = require("./loader/parsers/textures/loadTextures.js"), loadVideo = require("./loader/parsers/textures/loadVideo.js"), createTexture = require("./loader/parsers/textures/utils/createTexture.js"), resolveTextureUrl = require("./resolver/parsers/resolveTextureUrl.js"), checkDataUrl = require("./utils/checkDataUrl.js"), checkExtension = require("./utils/checkExtension.js"), convertToList = require("./utils/convertToList.js"), copySearchParams = require("./utils/copySearchParams.js"), createStringVariations = require("./utils/createStringVariations.js"), isSingleItem = require("./utils/isSingleItem.js");
exports.Assets = Assets.Assets;
exports.AssetsClass = Assets.AssetsClass;
exports.Cache = Cache.Cache;
exports.cacheTextureArray = cacheTextureArray.cacheTextureArray;
exports.detectAvif = detectAvif.detectAvif;
exports.detectWebp = detectWebp.detectWebp;
exports.detectDefaults = detectDefaults.detectDefaults;
exports.detectWebm = detectWebm.detectWebm;
exports.detectMp4 = detectMp4.detectMp4;
exports.detectOgv = detectOgv.detectOgv;
exports.LoaderParserPriority = LoaderParser.LoaderParserPriority;
exports.loadJson = loadJson.loadJson;
exports.loadTxt = loadTxt.loadTxt;
exports.getFontFamilyName = loadWebFont.getFontFamilyName;
exports.loadWebFont = loadWebFont.loadWebFont;
exports.loadSVG = loadSVG.loadSVG;
exports.loadImageBitmap = loadTextures.loadImageBitmap;
exports.loadTextures = loadTextures.loadTextures;
exports.loadVideo = loadVideo.loadVideo;
exports.createTexture = createTexture.createTexture;
exports.resolveTextureUrl = resolveTextureUrl.resolveTextureUrl;
exports.checkDataUrl = checkDataUrl.checkDataUrl;
exports.checkExtension = checkExtension.checkExtension;
exports.convertToList = convertToList.convertToList;
exports.copySearchParams = copySearchParams.copySearchParams;
exports.createStringVariations = createStringVariations.createStringVariations;
exports.isSingleItem = isSingleItem.isSingleItem;
//# sourceMappingURL=index.js.map
