"use strict";
var TranscoderWorkerWrapper = require("./TranscoderWorkerWrapper.js");
const _TranscoderWorker = class _TranscoderWorker2 {
  constructor() {
    this.requests = {}, this.onMessage = (e) => {
      const data = e.data;
      if (data.type === "init") {
        if (!data.success)
          throw new Error("BasisResource.TranscoderWorker failed to initialize.");
        this.isInit = !0, this.onInit();
      } else if (data.type === "transcode") {
        --this.load;
        const requestID = data.requestID;
        data.success ? this.requests[requestID].resolve(data) : this.requests[requestID].reject(), delete this.requests[requestID];
      }
    }, this.isInit = !1, this.load = 0, this.initPromise = new Promise((resolve) => {
      this.onInit = resolve;
    }), _TranscoderWorker2.wasmSource || console.warn("resources.BasisResource.TranscoderWorker has not been given the transcoder WASM binary!"), this.worker = new Worker(_TranscoderWorker2.workerURL), this.worker.onmessage = this.onMessage, this.worker.postMessage({
      type: "init",
      jsSource: _TranscoderWorker2.jsSource,
      wasmSource: _TranscoderWorker2.wasmSource
    });
  }
  /** Generated URL for the transcoder worker script. */
  static get workerURL() {
    if (!_TranscoderWorker2._workerURL) {
      let workerSource = TranscoderWorkerWrapper.TranscoderWorkerWrapper.toString();
      const beginIndex = workerSource.indexOf("{"), endIndex = workerSource.lastIndexOf("}");
      workerSource = workerSource.slice(beginIndex + 1, endIndex), _TranscoderWorker2.jsSource && (workerSource = `${_TranscoderWorker2.jsSource}
${workerSource}`), _TranscoderWorker2._workerURL = URL.createObjectURL(new Blob([workerSource]));
    }
    return _TranscoderWorker2._workerURL;
  }
  /** @returns a promise that is resolved when the web-worker is initialized */
  initAsync() {
    return this.initPromise;
  }
  /**
   * Creates a promise that will resolve when the transcoding of a *.basis file is complete.
   * @param basisData - *.basis file contents
   * @param rgbaFormat - transcoding format for RGBA files
   * @param rgbFormat - transcoding format for RGB files
   * @returns a promise that is resolved with the transcoding response of the web-worker
   */
  async transcodeAsync(basisData, rgbaFormat, rgbFormat) {
    ++this.load;
    const requestID = _TranscoderWorker2._tempID++, requestPromise = new Promise((resolve, reject) => {
      this.requests[requestID] = {
        resolve,
        reject
      };
    });
    return this.worker.postMessage({
      requestID,
      basisData,
      rgbaFormat,
      rgbFormat,
      type: "transcode"
    }), requestPromise;
  }
  /**
   * Loads the transcoder source code
   * @param jsURL - URL to the javascript basis transcoder
   * @param wasmURL - URL to the wasm basis transcoder
   * @returns A promise that resolves when both the js and wasm transcoders have been loaded.
   */
  static loadTranscoder(jsURL, wasmURL) {
    const jsPromise = fetch(jsURL).then((res) => res.text()).then((text) => {
      _TranscoderWorker2.jsSource = text;
    }), wasmPromise = fetch(wasmURL).then((res) => res.arrayBuffer()).then((arrayBuffer) => {
      _TranscoderWorker2.wasmSource = arrayBuffer;
    });
    return Promise.all([jsPromise, wasmPromise]).then((data) => (this._onTranscoderInitializedResolve(), data));
  }
  /**
   * Set the transcoder source code directly
   * @param jsSource - source for the javascript basis transcoder
   * @param wasmSource - source for the wasm basis transcoder
   */
  static setTranscoder(jsSource, wasmSource) {
    _TranscoderWorker2.jsSource = jsSource, _TranscoderWorker2.wasmSource = wasmSource;
  }
};
_TranscoderWorker.onTranscoderInitialized = new Promise((resolve) => {
  _TranscoderWorker._onTranscoderInitializedResolve = resolve;
}), _TranscoderWorker._tempID = 0;
let TranscoderWorker = _TranscoderWorker;
exports.TranscoderWorker = TranscoderWorker;
//# sourceMappingURL=TranscoderWorker.js.map
