import { ExtensionType, extensions } from "@pixi/core";
import { BasisParser } from "./BasisParser.mjs";
const detectBasis = {
  extension: {
    type: ExtensionType.DetectionParser,
    priority: 3
  },
  test: async () => !!(BasisParser.basisBinding && BasisParser.TranscoderWorker.wasmSource),
  add: async (formats) => [...formats, "basis"],
  remove: async (formats) => formats.filter((f) => f !== "basis")
};
extensions.add(detectBasis);
export {
  detectBasis
};
//# sourceMappingURL=detectBasis.mjs.map
