import { LINE_CAP, LINE_JOIN } from '@pixi/graphics';
import { FillStyle } from './FillStyle.mjs';

var LINE_SCALE_MODE = /* @__PURE__ */ ((LINE_SCALE_MODE2) => {
  LINE_SCALE_MODE2["NONE"] = "none";
  LINE_SCALE_MODE2["NORMAL"] = "normal";
  LINE_SCALE_MODE2["HORIZONTAL"] = "horizontal";
  LINE_SCALE_MODE2["VERTICAL"] = "vertical";
  return LINE_SCALE_MODE2;
})(LINE_SCALE_MODE || {});
class LineStyle extends FillStyle {
  clone() {
    return this.copyTo(new LineStyle());
  }
  // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
  copyTo(obj) {
    obj.color = this.color;
    obj.alpha = this.alpha;
    obj.texture = this.texture;
    obj.matrix = this.matrix;
    obj.shader = this.shader;
    obj.visible = this.visible;
    obj.width = this.width;
    obj.alignment = this.alignment;
    obj.cap = this.cap;
    obj.join = this.join;
    obj.miterLimit = this.miterLimit;
    obj.scaleMode = this.scaleMode;
    return obj;
  }
  /**
   * returns width multiplied by scaleMode
   */
  packLineScale() {
    switch (this.scaleMode) {
      case "normal" /* NORMAL */:
        return 1;
      case "horizontal" /* HORIZONTAL */:
        return 2;
      case "vertical" /* VERTICAL */:
        return 3;
      default:
        return 0;
    }
  }
  reset() {
    super.reset();
    this.smooth = true;
    this.color = 0;
    this.width = 0;
    this.alignment = 0.5;
    this.cap = LINE_CAP.BUTT;
    this.join = LINE_JOIN.MITER;
    this.miterLimit = 10;
    this.scaleMode = "normal" /* NORMAL */;
  }
}

export { LINE_SCALE_MODE, LineStyle };
//# sourceMappingURL=LineStyle.mjs.map
