'use strict';

var core = require('@pixi/core');
var CircleBuilder = require('./CircleBuilder.js');
var PolyBuilder = require('./PolyBuilder.js');
var RectangleBuilder = require('./RectangleBuilder.js');
var RoundedRectangleBuilder = require('./RoundedRectangleBuilder.js');

const FILL_COMMANDS = {
  [core.SHAPES.POLY]: new PolyBuilder.PolyBuilder(),
  [core.SHAPES.CIRC]: new CircleBuilder.CircleBuilder(),
  [core.SHAPES.ELIP]: new CircleBuilder.CircleBuilder(),
  [core.SHAPES.RECT]: new RectangleBuilder.RectangleBuilder(),
  [core.SHAPES.RREC]: new RoundedRectangleBuilder.RoundedRectangleBuilder()
};

exports.CircleBuilder = CircleBuilder.CircleBuilder;
exports.PolyBuilder = PolyBuilder.PolyBuilder;
exports.RectangleBuilder = RectangleBuilder.RectangleBuilder;
exports.RoundedRectangleBuilder = RoundedRectangleBuilder.RoundedRectangleBuilder;
exports.FILL_COMMANDS = FILL_COMMANDS;
//# sourceMappingURL=index.js.map
